export const processData = (productDetails, otherData) => {
    let groupProduct = [];
    for (let item = 0; item < productDetails.length; item++) {
        let external = {};
        if (productDetails[item].type == "External/Affiliate Product") {
            productDetails[item].metadata.find((i) => {
                if (i?.key == "meta_external_product") {
                    external = i?.value;
                    return i?.value;
                }
            });
        } else if (productDetails[item].type == "Simple Product") {
            productDetails[item].metadata.filter((i) => {
                if (
                    i?.key == "meta_stock_status" ||
                    i?.key == "meta_individual_sale"
                ) {
                    const key = i?.key.slice(i?.key.indexOf("_") + 1);
                    external = {
                        ...external,
                        [key]: i?.value,
                    };
                    return "";
                }
            });
        }
        groupProduct = [
            ...groupProduct,
            { ...productDetails[item], ...otherData[item], ...external },
        ];
    }
    return groupProduct;
};
